@extends('admin.layouts.app')

@section('title', 'Data Karyawan')

@section('content')

    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h4 class="fw-bold mb-1">Data Karyawan</h4>
            <small class="text-muted">Manajemen data karyawan</small>
        </div>

        <button class="btn btn-primary btn-sm d-flex align-items-center" data-bs-toggle="modal"
            data-bs-target="#tambahKaryawan">
            <i class="fas fa-plus me-2"></i>Tambah Data
        </button>
    </div>

    <div class="card shadow-sm border-0">
        <div class="card-body">

            <table class="table table-hover align-middle">
                <thead class="table-light">
                    <tr>
                        <th>#</th>
                        <th>NIP</th>
                        <th>Nama</th>
                        <th>Departemen</th>
                        <th>Jabatan</th>
                        <th>Status</th>
                        <th>Wajah Terdaftar</th>
                        <th class="text-center">Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($karyawan as $item)
                        <tr>
                            <td>{{ $loop->iteration }}</td>
                            <td>{{ $item->nip }}</td>
                            <td>{{ $item->user->nama ?? '-' }}</td>
                            <td>{{ $item->departemen->nama ?? '-' }}</td>
                            <td>
                                <span class="badge bg-info text-dark">
                                    {{ $item->jabatan->nama_jabatan ?? '-' }}
                                </span>
                            </td>
                            <td>
                                <span class="badge {{ $item->status == 'aktif' ? 'bg-success' : 'bg-secondary' }}">
                                    {{ $item->status }}
                                </span>
                            </td>
                            <td>{{ $item->wajah_terdaftar }}</td>
                            <td class="text-center">
                                <button data-bs-target="#ubahKaryawan{{ $item->id }}" data-bs-toggle="modal"
                                    class="btn btn-sm btn-warning">
                                    <i class="fas fa-edit"></i>
                                </button>
                                <button class="btn btn-sm btn-danger" data-bs-toggle="modal"
                                    data-bs-target="#hapusKaryawan{{ $item->id }}">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>

        </div>
        @foreach ($karyawan as $item)
            @include('admin.karyawan.edit')
            @include('admin.karyawan.delete')
        @endforeach
    </div>
    @include('admin.karyawan.create')


@endsection
